﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using UnityEngine;

public class MissionsCoreConfiguration : ConfigurationElement
{
    public int MoneyRoundFactor { get; private set; }
    public MissionsTimeConfiguration Time { get; private set; }

    public MissionsCoreConfiguration() : base("MissionsCore")
    {

    }

    public override bool Parse(XElement configElem)
    {
        try
        {
            MoneyRoundFactor = Convert.ToInt32(configElem.Element("MoneyRoundFactor").Value);

            //Create our sub-configuration objects
            Time = new MissionsTimeConfiguration();

            //Let's try to parse all of our sub configurations, passing in the corresponding parent elements
            if (Time.Parse(configElem.Element("Time")))
            {
                return true;    //Parsed everything successfully!
            }

            else
            {
                Debug.LogError("ERROR: Failed to parse missions time configuration.");
            }

            return false;   //We must have failed to parse one of the configurations
        }

        catch (Exception ex)
        {
            Debug.LogError("ERROR: Caught an exception when parsing missions core configuration. The exception is: " + ex);
            Preloader.ExceptionMessage = ex.ToString();
            return false;
        }
    }
}
